﻿<#
 # Download a single file from FileHold
 # Copyright(C)2016 FileHold Systems Inc. All rights reserved.
 #
 # Adjust the following three variables (fileHoldUrl, userId, password) to match your environment.
 # You must pass the FileHold id as the first parameter. You can optionally pass the temporary filename as the second parameter.
 #>
Param( 
    [Parameter(Mandatory=$TRUE)][string]$fileHoldId,
    [string]$tempFile = "tempFile.pdf"
)

#########################################################################
# Adjust these variables to match your environment.
#########################################################################
$fileHoldUrl = "http://fileholdtest4/fh/filehold" 
$userId = "sysadm"
$password = "12345"
#########################################################################

    
# Assumes the script is running on the FileHold server. If not, this must point to a location with this dll
Add-Type -Path 'C:\Program Files\FileHold Systems\Application Server\fileholdadm\FileHold.Common.dll'

# Create a reference to the session manager web service
$uri = $fileHoldUrl + "/UserRoleManager/SessionManager.asmx?WSDL"
$urmSessionManagerProxy = New-WebServiceProxy -Uri $uri

# Create a new FileHold sessions. Note that custom clients must always use the custom client type
$sessionId = $urmSessionManagerProxy.StartSession( $userId, $password, [FileHold.Common.Client]::CustomClient.value__ )

# These next few lines are only needed to update the user activity log
$scriptName = $MyInvocation.MyCommand.Name
$clientVersion = "14.2"
$serverVersion = $null
$compatible = $urmSessionManagerProxy.CheckApiVersionAndLogClientInfo( $sessionId, `
                    $clientVersion, [ref]$serverVersion, `
                    $scriptName, `
                    (get-netadapter | get-netipaddress | ? addressfamily -eq 'IPv4').ipaddress )


# Build a direct document link and include the session that was just created
$documentAddress = $fileHoldUrl + "/WebClient/LoginForm.aspx?sessionId=" + $sessionId + "&originalUrl=" + 
                            [System.Web.HttpUtility]::UrlEncode( $fileHoldUrl + "/WebClient/ViewerForm.aspx?docId=" + $fileHoldId )

# Do not display progress while downloading
$progressPreference = 'silentlyContinue'

# Download the document from FileHold
Invoke-WebRequest $documentAddress -outfile $tempFile