﻿<#
    #############################################################################################
    .SYNOPSIS
    Copyright(C)2019 FileHold Systems Inc.
    #############################################################################################
#>
$BuildNumber = '20210817.1'

# Load FH API functions. Assume ps1 is in same location as this script.
Import-Module "$PSScriptRoot\FileHoldApi.psm1" -Force 

function Login
  {
    Write-Information -MessageData "Copy FileHold schema $(Get-Date) ($($MyInvocation.MyCommand.Name) $BuildNumber)"

    if ( $WhatIfPreference ) 
    {
      Write-Verbose -Message 'Simulate mode is enabled. The system will not be updated. Invoke without ""-WhatIf"" to make changes.'
    }
    
    if ( !$ReuseSession )
    {
        if ( $Domain )
        {
          Start-FileHoldSession -HostAddress $Server -UserId $UserId -Password $Password -Domain $Domain -BuildNumber $BuildNumber -InformationAction $InformationPreference
        }
        if ( $UserId -and $Password )
        {
          Start-FileHoldSession -HostAddress $Server -UserId $UserId -Password $Password -BuildNumber $BuildNumber -InformationAction $InformationPreference
        }
        else
        {
          Start-FileHoldSession -HostAddress $Server -UseIntegratedAuthentication -BuildNumber $BuildNumber 
        }
    }      
}

function Copy-FileHoldSchema
{
  <#
      #############################################################################################
      .SYNOPSIS

      .NOTES
      Use -WhatIf to perform all functions except updating the field.

      DISCLAIMER. 
    
      FileHold makes no claims to the correctness, fitness for purpose, or
      anything else related to this script. It is provided as an example only.
      It is intended to be used or modified by a person skilled with Windows,
      PowerShell, .NET programming, and the FileHold API. Never use it on a
      production system without thouroughly testing it first and never use it
      in production if you do not fit the skilled person description above.
      #############################################################################################
  #>
  [CmdletBinding(SupportsShouldProcess = $true)]
  Param (
    [Parameter(
        ValueFromPipeline = $true,
        HelpMessage='A list of document versions to remove.',
        Mandatory = $true
    )]
    [Object]$ValueList,
    
    [Parameter(
        Mandatory = $false, 
        HelpMessage='Name or URI for FileHold server. HTTP assumed if protocol not specified.'
    )]
    [uri]$Server = 'localhost',
    
    [string]$UserId = $null,
    
    [string]$Password = $null,
    
    [string]$Domain = $null,
    [switch]$PreserveSession = $false,
    [switch]$ReuseSession= $false,

        [Parameter(
            Mandatory = $true
        )]
    [string]$SourceName
  )
  
    Begin
    {
        Login
    
        $schemas = (DocumentSchemaManager).GetDocumentSchemasOverviewList()

        $sourceId = $schemas.Where( { $_.Name -ieq $SourceName } ).DocumentSchemaId
        if ( $sourceId -gt 0 )
        {
            $sourceSchema = (DocumentSchemaManager).GetDocumentSchema( $sourceId )
            $backupName = $sourceSchema.Name
            $backupDescription = $sourceSchema.Description
        }
        else
        {
            Throw "Document schema ""$SourceName"" does not exist."
        }
    }

    Process
    {
        foreach ( $DestinationName in $ValueList )
        {
            $schemas = (DocumentSchemaManager).GetDocumentSchemasOverviewList()
            if ( $schemas.Where( { $_.Name -ieq $DestinationName } ))
            {
                Throw "Destination schema ""$DestinationName"" already exists."
            }
            else
            {
                $sourceSchema.Name = $DestinationName
                $sourceSchema.Description = "$backupDescription -- copied from '$backupName' ($($sourceSchema.Id))"
                # $PSCmdlet.ShouldProcess first argument is for target, the second is for action
                If($PSCmdlet.ShouldProcess( $backupName, "Copy to schema $DestinationName" ))
                {
                    $null = (DocumentSchemaManager).AddDocumentSchema( $sourceSchema )
                    Write-Information -MessageData "Created schema '$($DestinationName)'"
                }
            }
        }
    }

    End
    {
        if ( !$PreserveSession )
        {
            Stop-FileHoldSession -InformationAction $InformationPreference
        }
    }
}

#'Sed','ut','perspiciatis','unde','omnis','iste','natus','error','sit','voluptatem','accusantium','doloremque','laudantium','totam','rem','aperiam','eaque','ipsa','quae','ab','illo','inventore','veritatis','et','quasi','architecto','beatae','vitae','dicta','sunt','explicabo','Nemo','enim','ipsam','quia','voluptas','aspernatur','odit','aut','fugit','consequuntur','magni','dolores','eos','qui','ratione','sequi','nesciunt','Neque','porro','quisquam','est','ipsum','dolor','amet','consectetur','adipisci','non','numquam','eius','modi','tempora','incidunt','labore','dolore','magnam','aliquam','quaerat','ad','minima','veniam','nostrum','exercitationem','ullam','corporis','suscipit','laboriosam','nisi','aliquid','ex','commodi','Quis','autem','iure','reprehenderit','in','ea','voluptate','velit','esse','quam','nihil','molestiae','consequatur','vel','illum','dolorem','eum','fugiat','quo','nulla','pariatur'`
# |Copy-FileHoldSchema -UserId sysadm -Password '12345' -SourceName 'Schema-1' -InformationAction Continue -Whatif

'schema-1c', 'schema-1d' |Copy-FileHoldSchema -UserId sysadm -Password '12345' -SourceName 'Schema-1' -InformationAction Continue 
